<?php
/**
 * ----------------------------------------------------
 * Process Anggota (CRUD)
 * ----------------------------------------------------
 */

require_once '../config/config.php';
require_once '../config/database.php';
require_once '../config/auth.php';

// Pastikan hanya admin & petugas
if (!in_array($user_role, ['admin', 'petugas'])) {
    die('Akses ditolak');
}

$action = $_POST['action'] ?? $_GET['action'] ?? '';

/**
 * ----------------------------------------------------
 * INSERT DATA
 * ----------------------------------------------------
 */
if ($action === 'insert') {

    $no_anggota = trim($_POST['no_anggota']);
    $nama       = trim($_POST['nama']);
    $alamat     = trim($_POST['alamat']);
    $no_hp      = trim($_POST['no_hp']);

    $stmt = $db->prepare("
        INSERT INTO anggota (no_anggota, nama, alamat, no_hp, created_at)
        VALUES (?, ?, ?, ?, NOW())
    ");
    $stmt->execute([$no_anggota, $nama, $alamat, $no_hp]);

    header("Location: ../modules/anggota/index.php");
    exit;
}

/**
 * ----------------------------------------------------
 * UPDATE DATA
 * ----------------------------------------------------
 */
if ($action === 'update') {

    $id         = $_POST['id'];
    $no_anggota = trim($_POST['no_anggota']);
    $nama       = trim($_POST['nama']);
    $alamat     = trim($_POST['alamat']);
    $no_hp      = trim($_POST['no_hp']);

    $stmt = $db->prepare("
        UPDATE anggota
        SET no_anggota = ?, nama = ?, alamat = ?, no_hp = ?
        WHERE id = ?
    ");
    $stmt->execute([$no_anggota, $nama, $alamat, $no_hp, $id]);

    header("Location: ../modules/anggota/index.php");
    exit;
}

/**
 * ----------------------------------------------------
 * DELETE DATA
 * ----------------------------------------------------
 */
if ($action === 'delete') {

    $id = $_GET['id'];

    $stmt = $db->prepare("DELETE FROM anggota WHERE id = ?");
    $stmt->execute([$id]);

    header("Location: ../modules/anggota/index.php");
    exit;
}

// Jika action tidak dikenal
die('Aksi tidak valid');
